/*
 * MidiMessage.h
 *
 *  Created on: Mar 23, 2015
 *      Author: Austin Riffle
 */

#ifndef MIDIMESSAGE_H_
#define MIDIMESSAGE_H_

#include "MidiDefinitions.h"

namespace midi
{

class MidiMessage
{
public:
    /*! The maximum size for the System Exclusive array.
    */
	const static uint16_t sysExMaxSize = 128;

    /*! The MIDI channel on which the message was recieved.
     \n Value goes from 1 to 16.
     */
    Channel channel;

    /*! The type of the message
     (see the MidiType enum for types reference)
     */
    MidiType type;

    /*! The first data byte.
     \n Value goes from 0 to 127.
     */
    DataByte data1;

    /*! The second data byte.
     If the message is only 2 bytes long, this one is null.
     \n Value goes from 0 to 127.
     */
    DataByte data2;

    /*! System Exclusive dedicated byte array.
     \n Array length is stocked on 16 bits,
     in data1 (LSB) and data2 (MSB)
     */
    DataByte sysexArray[sysExMaxSize];

    /*! This boolean indicates if the message is valid or not.
     There is no channel consideration here,
     validity means the message respects the MIDI norm.
     */
    bool valid;

    inline unsigned getSysExSize() const
    {
        const unsigned size = unsigned(data2) << 8 | data1;
        return size > sysExMaxSize ? sysExMaxSize : size;
    }
};

}
#endif /* MIDIMESSAGE_H_ */
